IF NOT OBJECT_ID('UFD_TBL_INTERVALO_TEMPO') IS NULL
	BEGIN 
		DROP FUNCTION UFD_TBL_INTERVALO_TEMPO
	END
	
GO	

CREATE FUNCTION UFD_TBL_INTERVALO_TEMPO (@MIN_INTERVALO INT)
RETURNS @RS_RETURN TABLE (HORA DATETIME, HORA_FIM DATETIME)

AS
	BEGIN

		DECLARE @CONT		INT
		DECLARE @CONT_I		INT
		
		SET @CONT = (24 * 60) / @MIN_INTERVALO 
		SET @CONT_I = 0		

		WHILE @CONT_I < @CONT
			BEGIN 
				SET @CONT_I = @CONT_I + 1				
				
				INSERT INTO @RS_RETURN 
					VALUES (CONVERT(VARCHAR(10), DATEADD(minute, (@MIN_INTERVALO * @CONT_I), '00:00:00'), 108), 
							CONVERT(VARCHAR(10), DATEADD(SECOND, (60 * @MIN_INTERVALO * (@CONT_I + 1)) - 1, '00:00:00'), 108))
									
			END
	
		RETURN 

	END